%% Sistema NMF No Supervisado
function[W,H,D_KL,Y,X,n_iterations]=UNSUPERVISED_NMF(X,b,i_max,lambda,eta)

% A continuacin calculamos el nmero de bins en frecuencia y frames en
% tiempo

[F,T]=size(X);

% Para el calculo de las reglas de actualizacin multiplicativas se usara
% la Kullback-Leibler (KL) divergencia
beta=1;

% La matriz de entrada se obtendra como X aprox Y=W*H

% Inicializaremos a un valor aleatorio las matrices que componen la salida
% Wc,Hc,Wp y Hp. As? mismo se normaliza a 1 las columnas de las matriz de
% bases espectrales Wp y Wc.

W=rand(F,b);
H=rand(b,T);
Fc=sqrt(sum(W.^2));
W=W./repmat(Fc,F,1);
H=(repmat(Fc,T,1)').*H;
Y=W*H+eps;
% Se aplican las reglas de actualizacin multiplicativas

for i=1:i_max
    
    
    %Se actualizan las bases espectrales de sonidos del corazon
    
    W = W .* (((Y.^(beta-2)+eps).*X)*H')./((Y.^(beta-1))*H'+eps);
    
    W(W<0)=eps; % Cualquier valor negativo vale 0
    Fc=sqrt(sum(W.^2));
    W=W./repmat(Fc,F,1);
    H=(repmat(Fc,T,1)').*H;
    
    Y=W*H+eps;
    
    %Se actualizan las activaciones de dichas bases espectrales
    
    H = H .* (W'*((Y.^(beta-2)+eps).*X))./(W'*(Y.^(beta-1))+lambda*(F/b)+eps);%(9)
    
    
    H(H<0)=eps; % Cualquier valor negativo vale 0
    
    Y=W*H+eps;
    
    %Calculamos la distorsin
    D_KL(i)=norm((X(:).*(log(X(:))-log(Y(:)))+ Y(:)-X(:)),'fro')+lambda*norm(H,1);
    
    %Criterio de parada
    
    umbral=D_KL(i)*eta;
    
    if i>1
        if (D_KL(i-1)-D_KL(i))<umbral
            n_iterations=i;
            break;
        else
            n_iterations=i;
        end
    end
    
end
end
